{
	"medicinalPlant":{
		"type":"landRessource",
		"age":"woodenAge",
		"no":0,
		"picture":{"file":"medicinalPlant.png",
				   "file50":"medicinalPlant50.atf",
				   "file100":"medicinalPlant100.atf",
				   "file200":"medicinalPlant200.atf"},
		"name":{"EN":"medicinal plant",
				"FR":"plantes médicinales",
				"DE":"Heilkraut"},
		"description":{"EN":"The medicinal plant provide medicinal herbs to restore health.",
					   "FR":"Les plantes médicinales fournissent des herbes médicinales qui permettent de regagner de la santé.",
					   "DE":"Das Heilkraut stellt Heilkräuter zur verfügung welche man zum heilen verwenden kann."},
		"rate":25,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":25},
			"bonusSkill":"forestry",
			"xpSkill":{"forestry":25},
			"xpSecondaryCharacteristic":{"willpower":25},
			"prebuild":{"id":"sprout", "time":12.5, "anim":"pop"}
		},
		"quantity":25,
		"produce":[{
				"time":0.5,
				"gainRessource":{"medicinalHerbs":1},
				"sound":"soundVegetable",
				"anim":"shake",
				"bonusSkill":"picking",
				"costPrimaryCharacteristic":{"stamina":1},
				"xpSecondaryCharacteristic":{"strength":1},
				"xpSkill":{"picking":1},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"bush":{
		"type":"landRessource",
		"age":"woodenAge",
		"no":1,
		"picture":{"file":"bush.png",
				   "file50":"bush50.atf",
				   "file100":"bush100.atf",
				   "file200":"bush200.atf"},
		"name":{"EN":"bush",
				"FR":"buisson",
				"DE":"Beeren strauch"},
		"description":{"EN":"The bush provide fruits to restore stamina.",
					   "FR":"Le buisson fournit des fruits qui permettent de regagner de l'énergie.",
					   "DE":"Vom Beeren strauch bekommt man köstliche blaubeeren zum auffüllen der Ausdauer."},
		"rate":20,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":20},
			"bonusSkill":"forestry",
			"xpSkill":{"forestry":20},
			"xpSecondaryCharacteristic":{"willpower":20},
			"prebuild":{"id":"sprout", "time":10, "anim":"pop"}
		},
		"quantity":20,
		"produce":[{
				"time":0.5,
				"gainRessource":{"fruits":1},
				"sound":"soundVegetable",
				"anim":"shake",
				"bonusSkill":"picking",
				"xpSecondaryCharacteristic":{"rapidity":1},
				"xpSkill":{"picking":1},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"mushroomsPlant":{
		"type":"landRessource",
		"age":"woodenAge",
		"no":2,
		"picture":{"file":"mushroomsPlant.png",
				   "file100":"mushroomsPlant100.atf"},
		"name":{"EN":"mushrooms plant",
				"FR":"pousses de champignons",
				"DE":"Pilzstrauch"},
		"description":{"EN":"The mushrooms plant provide mushrooms to restore mana.",
					   "FR":"Les pousses de champignons fournissent des champignons qui permettent de regagner de la mana.",
					   "DE":"Der Pilzstrauch bietet genießbare Pilze zum auffüllen des Manas."},
		"rate":15,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":5},
			"bonusSkill":"forestry",
			"xpSkill":{"forestry":5},
			"xpSecondaryCharacteristic":{"willpower":5},
			"prebuild":{"id":"sprout", "time":12.5, "anim":"pop"}
		},
		"quantity":15,
		"produce":[{
				"time":0.5,
				"gainRessource":{"mushroom":1},
				"sound":"soundVegetable",
				"anim":"shake",
				"bonusSkill":"picking",
				"costPrimaryCharacteristic":{"stamina":1},
				"xpSecondaryCharacteristic":{"rapidity":1},
				"xpSkill":{"picking":1},
				"repeat":true,
				"quantity":-1
			}],
		"width":24,
		"height":24
	},
	"tree":{
		"type":"landRessource",
		"age":"woodenAge",
		"no":3,
		"picture":{"file":"tree.png",
				   "file100":"tree100.atf"},
		"name":{"EN":"tree",
				"FR":"arbre",
				"DE":"Baum"},
		"description":{"EN":"The tree provide wood to construct buildings.",
					   "FR":"L'arbre fournit du bois pour construire des bâtiments.",
					   "DE":"Der Baum stellt Holz zur verfügung welches zum Bauen verwendet werden kann."},
		"rate":75,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":50},
			"bonusSkill":"forestry",
			"xpSkill":{"forestry":50},
			"xpSecondaryCharacteristic":{"willpower":50},
			"prebuild":{"id":"sproutL", "time":25, "anim":"pop"}
		},
		"quantity":50,
		"produce":[{
				"time":0.5,
				"gainRessource":{"wood":1},
				"sound":"soundTree",
				"anim":"shake",
				"bonusSkill":"woodcutting",
				"costPrimaryCharacteristic":{"stamina":1},
				"xpSecondaryCharacteristic":{"strength":1},
				"xpSkill":{"woodcutting":1},
				"repeat":true,
				"quantity":-1
			}],
		"width":64,
		"height":64
	},
	"deer":{
		"type":"animal",
		"age":"woodenAge",
		"no":4,
		"picture":{"file":"deer.png",
				   "file100":"deer100.atf"},
		"name":{"EN":"deer",
				"FR":"cerf",
				"DE":"Hirsch"},
		"pluralName":{"EN":"deers", "FR":"cerfs", "DE":"Hirsche"},
		"description":{"EN":"The deer provide raw meat and animal skins.",
					   "FR":"Le cerf fournit de la viande crue et des peaux.",
					   "DE":"Der Hirsch, einst getötet bietet sein kadaver Rohes Fleisch und Tierhaut."},
		"rate":10,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":15},
			"bonusSkill":"zoology",
			"xpSkill":{"zoology":15},
			"xpSecondaryCharacteristic":{"willpower":15},
			"prebuild":{"id":"cage", "time":7.5, "anim":"pop"}
		},
		"width":40,
		"height":48,
		"health":50,
		"defense":100,
		"speed":7,
		"death":{
			"build":{
				"name":"deerCarcass",
				"quantity":1
			}
		}
	},
	"deerCarcass":{
		"type":"landRessource",
		"picture":{"file":"deerCarcass.png",
				   "file100":"deerCarcass100.atf"},
		"name":{"EN":"deer carcass",
				"FR":"carcasse de cerf",
				"DE":"Hirschkadaver"},
		"description":{"EN":"The deer carcass provide rawmeat and animale skin to eat and manufacture clothes.",
					   "FR":"La caracasse de cerf fournit de la viande crue et des peaux pour confectionner des vêtements.",
					   "DE":"Der Hirschkadaver bietet Rohes Fleisch zum verarbeiten und essen, und Tiehaut zur Herstellung von Rüstung und Kleidung."},
		"quantity":10,
		"produce":[{
				"time":1,
				"gainRessource":{"rawMeat":1, "animalSkins":1},
				"sound":"soundVegetable",
				"anim":"shake",
				"bonusSkill":"hunting",
				"costPrimaryCharacteristic":{"stamina":1},
				"xpSecondaryCharacteristic":{"address":2},
				"xpSkill":{"hunting":2},
				"repeat":true,
				"quantity":-1
			}],
		"width":48,
		"height":30
	},
	"rock":{
		"type":"landRessource",
		"age":"stoneAge",
		"no":5,
		"picture":{"file":"rock.png",
				   "file100":"rock100.atf"},
		"name":{"EN":"rock",
				"FR":"rocher",
				"DE":"Felsen"},
		"description":{"EN":"The rock provide stone to construct buildings.",
					   "FR":"Le rocher fournit de la pierre pour construire des bâtiments.",
					   "DE":"Der Felsen bietet steine zur verarbeitung oder der Konstruktion von Gebäuden."},
		"age":"stoneAge",
		"rate":15,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":30},
			"bonusSkill":"lithology",
			"xpSkill":{"lithology":30},
			"xpSecondaryCharacteristic":{"intelligence":30},
			"prebuild":{"id":"pebble", "time":45, "anim":"pop"}
		},
		"quantity":30,
		"produce":[{
				"time":1,
				"gainRessource":{"stone":1},
				"sound":"soundRock",
				"anim":"shake",
				"bonusSkill":"stonecutting",
				"costPrimaryCharacteristic":{"stamina":2},
				"xpSecondaryCharacteristic":{"strength":2},
				"xpSkill":{"stonecutting":2},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"grainField":{
		"type":"landRessource",
		"age":"stoneAge",
		"no":6,
		"picture":{"file":"grainField.png",
				   "file100":"grainField100.atf"},
		"name":{"EN":"grain field",
				"FR":"champ de céréales",
				"DE":"Getreidefeld"},
		"description":{"EN":"The grain field provide grain to bake bread.",
					   "FR":"Le champ de céréales fournit des céréales pour cuire du pain.",
					   "DE":"Das Getreidefeld bietet Getreide zur verarbeitung zum Brot oder zur züchtung von Pferden."},
		"rate":0,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":5},
			"bonusSkill":"farming",
			"xpSkill":{"farming":5},
			"xpSecondaryCharacteristic":{"willpower":5},
			"prebuild":{"id":"sproutS", "time":30, "anim":"pop"}
		},
		"quantity":5,
		"produce":[{
				"time":1,
				"gainRessource":{"grain":1},
				"sound":"soundVegetable",
				"anim":"shake",
				"bonusSkill":"harvesting",
				"costPrimaryCharacteristic":{"stamina":2},
				"xpSecondaryCharacteristic":{"rapidity":2},
				"xpSkill":{"harvesting":2},
				"repeat":true,
				"quantity":-1
			}],
		"width":24,
		"height":48
	},
	"pig":{
		"type":"animal",
		"age":"stoneAge",
		"no":7,
		"picture":{"file":"pig.png",
				   "file100":"pig100.atf"},
		"name":{"EN":"pig",
				"FR":"cochon",
				"DE":"Schwein"},
		"pluralName":{"EN":"pigs", "FR":"cochons", "DE":"Schweine"},
		"description":{"EN":"The pig provide raw meat.",
					   "FR":"Le cochon fournit de la viande crue.",
					   "DE":"Das Schwein, einst getötet bietet sein kadaver viel Rohes Fleisch."},
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":10},
			"bonusSkill":"breeding",
			"xpSkill":{"breeding":10},
			"xpSecondaryCharacteristic":{"willpower":10},
			"prebuild":{"id":"cage", "time":15, "anim":"pop"}
		},
		"width":32,
		"height":32,
		"health":10,
		"defense":50,
		"speed":2,
		"death":{
			"build":{
				"name":"pigCarcass",
				"quantity":1
			}
		}
	},
	"pigCarcass":{
		"type":"landRessource",
		"picture":{"file":"pigCarcass.png",
				   "file100":"pigCarcass100.atf"},
		"name":{"EN":"pig carcass",
				"FR":"carcasse de cochon",
				"DE":"Schweinkadaver"},
		"description":{"EN":"The pig carcass provide rawmeat to eat.",
					   "FR":"La caracasse de cochon fournit de la viande crue.",
					   "DE":"Der Schweinkadaver bietet eine menge Rohes Fleisch zur verarbeitung zu Nahrungsmitteln."},
		"quantity":30,
		"produce":[{
				"time":0.5,
				"gainRessource":{"rawMeat":2},
				"sound":"soundVegetable",
				"anim":"shake",
				"bonusSkill":"hunting",
				"costPrimaryCharacteristic":{"stamina":1},
				"xpSecondaryCharacteristic":{"address":2},
				"xpSkill":{"hunting":2},
				"repeat":true,
				"quantity":-2
			}],
		"width":32,
		"height":32
	},
	"sheep":{
		"type":"animal",
		"age":"stoneAge",
		"no":8,
		"picture":{"file":"sheep.png",
				   "file100":"sheep100.atf"},
		"name":{"EN":"sheep",
				"FR":"mouton",
				"DE":"Schaf"},
		"pluralName":{"EN":"sheeps", "FR":"moutons", "DE":"Schafe"},
		"description":{"EN":"The sheep provide wool.",
					   "FR":"Le mouton fournit de la laine.",
					   "DE":"Das Schaf bietet freiwillig seine wertvolle wolle an."},
		"rate":0,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":35},
			"bonusSkill":"breeding",
			"xpSkill":{"breeding":35},
			"xpSecondaryCharacteristic":{"willpower":35},
			"prebuild":{"id":"cage", "time":17.5, "anim":"pop"}
		},
		"quantity":18,
		"produce":[{
				"time":1,
				"gainRessource":{"wool":1},
				"sound":"soundVegetable",
				"bonusSkill":"sheepShearing",
				"costPrimaryCharacteristic":{"stamina":2},
				"xpSecondaryCharacteristic":{"rapidity":2},
				"xpSkill":{"sheepShearing":2},
				"repeat":true,
				"quantity":-1
			}],
		"width":40,
		"height":40,
		"health":25,
		"defense":100,
		"speed":3
	},
	"cage":{
		"type":"prebuild",
		"picture":{"file":"cage.png",
				   "file100":"cage100.atf"},
		"name":{"EN":"animal cage",
				"FR":"cage d'animal",
				"DE":"Tierkäfig"},
		"description":{"EN":"The animal cage will become an fully-grown animal.",
					   "FR":"La cage d'animal va devenir un animal mature.",
					   "DE":"Der Tierkäfig wird nach einigen sekunden zu einem ausgewachsenen Tier."},
		"width":32,
		"height":32
	},
	"ironOre":{
		"type":"landRessource",
		"age":"ironAge",
		"no":9,
		"picture":{"file":"ironOre.png",
				   "file100":"ironOre100.atf"},
		"name":{"EN":"iron ore",
				"FR":"minerai de fer",
				"DE":"Eisenerz"},
		"description":{"EN":"The iron ore provide iron to manufacture tools, weapons and armors.",
					   "FR":"Le minerai de fer fournit du fer pour fabriquer des outils, des armes et des armures.",
					   "DE":"Das Eisenerz bietet Eisen zur verarbeitung zu Eisenbarren welche für Werkzeuge, Waffen und Rüstungen benötigt werden."},
		"age":"ironAge",
		"rate":3,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":40},
			"bonusSkill":"prospecting",
			"xpSkill":{"prospecting":40},
			"xpSecondaryCharacteristic":{"willpower":40},
			"prebuild":{"id":"pebble", "time":60, "anim":"pop"}
		},
		"quantity":20,
		"produce":[{
				"time":1.5,
				"gainRessource":{"iron":1},
				"sound":"soundMineral",
				"anim":"shake",
				"bonusSkill":"mining",
				"costPrimaryCharacteristic":{"stamina":3},
				"xpSecondaryCharacteristic":{"endurance":3},
				"xpSkill":{"mining":3},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"crystalsOre":{
		"type":"landRessource",
		"age":"etherAge",
		"no":10,
		"picture":{"file":"crystalsOre.png",
				   "file100":"crystalsOre100.atf"},
		"name":{"EN":"crystals ore",
				"FR":"minerai de cristaux",
				"DE":"Kristallerz"},
		"description":{"EN":"The crystals ore provide crystals to manufacture magical items.",
					   "FR":"Le minerai de cristaux fournit des cristaux pour fabriquer de l'équipement magique.",
					   "DE":"Kristallerz bietet Kristalle welche zur Herstellung von Magischen Gegenständen benötigt werden."},
		"age":"etherAge",
		"rate":1,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":55},
			"bonusSkill":"gemmology",
			"xpSkill":{"gemmology":55},
			"xpSecondaryCharacteristic":{"intelligence":55},
			"prebuild":{"id":"crystalPebble", "time":82, "anim":"pop"}
		},
		"quantity":20,
		"produce":[{
				"time":2,
				"gainRessource":{"crystals":1},
				"sound":"soundCristal",
				"anim":"shake",
				"bonusSkill":"mining",
				"costPrimaryCharacteristic":{"stamina":4},
				"xpSecondaryCharacteristic":{"endurance":4},
				"xpSkill":{"mining":4},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"sulfurOre":{
		"type":"landRessource",
		"age":"goldenAge",
		"no":11,
		"picture":{"file":"sulfurOre.png",
				   "file100":"sulfurOre100.atf"},
		"name":{"EN":"sulfur ore",
				"FR":"minerai de soufre",
				"DE":"Schwefelerz"},
		"description":{"EN":"The sulfur ore provide sulfur to manufacture firearm ammo.",
					   "FR":"Le minerai de soufre fournit du soufre pour fabriquer des munitions d'armes à feu.",
					   "DE":"Schwefelerz bietet Schwefel zur Herstellung von Schusswaffen Munition"},
		"rate":1,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":60},
			"bonusSkill":"prospecting",
			"xpSkill":{"prospecting":60},
			"xpSecondaryCharacteristic":{"willpower":60},
			"prebuild":{"id":"pebble", "time":90, "anim":"pop"}
		},
		"quantity":18,
		"produce":[{
				"time":2.5,
				"gainRessource":{"sulfur":1},
				"sound":"soundMineral",
				"anim":"shake",
				"bonusSkill":"mining",
				"costPrimaryCharacteristic":{"stamina":5},
				"xpSecondaryCharacteristic":{"endurance":5},
				"xpSkill":{"mining":5},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"goldenOre":{
		"type":"landRessource",
		"age":"goldenAge",
		"no":12,
		"picture":{"file":"goldenOre.png",
				   "file100":"goldenOre100.atf"},
		"name":{"EN":"golden ore",
				"FR":"minerai d'or",
				"DE":"Golderz"},
		"description":{"EN":"The golden ore provide gold to manufacture jewelry.",
					   "FR":"Le minerai d'or fournit de l'or pour fabriquer des bijoux.",
					   "DE":"Golderz bietet goldstaub zur verarbeitung zu Gold welches für die Herstellung von Schmuck benötigt wird."},
		"rate":1,
		"build":{
			"buildable":"all",
			"costPrimaryCharacteristic":{"mana":65},
			"bonusSkill":"prospecting",
			"xpSkill":{"prospecting":65},
			"xpSecondaryCharacteristic":{"willpower":65},
			"prebuild":{"id":"pebble", "time":98, "anim":"pop"}
		},
		"quantity":20,
		"produce":[{
				"time":2.5,
				"gainRessource":{"gold":1},
				"sound":"soundMineral",
				"anim":"shake",
				"bonusSkill":"mining",
				"costPrimaryCharacteristic":{"stamina":5},
				"xpSecondaryCharacteristic":{"endurance":5},
				"xpSkill":{"mining":5},
				"repeat":true,
				"quantity":-1
			}],
		"width":32,
		"height":32
	},
	"sprout":{
		"type":"prebuild",
		"picture":{"file":"sprout.png",
				   "file100":"sprout100.atf"},
		"name":{"EN":"sprout",
				"FR":"pousse",
				"DE":"Sprössling"},
		"description":{"EN":"The sprout will soon become a plant.",
					   "FR":"La pousse va bientôt devenir une plante.",
					   "DE":"Der Sprössling wird in kurzer zeit zu einer Pflanze."},
		"width":32,
		"height":32
	},
	"sproutS":{
		"type":"prebuild",
		"picture":{"file":"sproutS.png",
				   "file100":"sproutS100.atf"},
		"name":{"EN":"sprout",
				"FR":"pousse",
				"DE":"Sprössling"},
		"description":{"EN":"The sprout will soon become a plant.",
					   "FR":"La pousse va bientôt devenir une plante.",
					   "DE":"Der Sprössling wird in kurzer zeit zu einer Pflanze."},
		"width":16,
		"height":16
	},
	"sproutL":{
		"type":"prebuild",
		"picture":{"file":"sproutL.png",
				   "file100":"sproutL100.atf"},
		"name":{"EN":"sprout",
				"FR":"pousse",
				"DE":"Sprössling"},
		"description":{"EN":"The sprout will soon become a plant.",
					   "FR":"La pousse va bientôt devenir une plante.",
					   "DE":"Der Sprössling wird in kurzer zeit zu einer Pflanze."},
		"width":64,
		"height":64
	},
	"pebble":{
		"type":"prebuild",
		"picture":{"file":"pebble.png",
				   "file100":"pebble100.atf"},
		"name":{"EN":"deposit",
				"FR":"gisement",
				"DE":"Kieselstein"},
		"description":{"EN":"The pebble will soon become a mineral ore.",
					   "FR":"Ce gisement va bientôt devenir un minerai.",
					   "DE":"Der Kleine Kieselstein wird schon bald zu einem vollwärtigen Erz Heranwachsen"},
		"width":32,
		"height":32
	},
	"crystalPebble":{
		"type":"prebuild",
		"picture":{"file":"crystalPebble.png",
				   "file100":"crystalPebble100.atf"},
		"name":{"EN":"crystal deposit",
				"FR":"gisement",
				"DE":"Kristallsplitter"},
		"description":{"EN":"The crystal pebble will soon become a crystal ore.",
					   "FR":"Ce gisement de cristaux va bientôt devenir un minerai de cristaux.",
					   "DE":"Der Kleine Kristallsplitter wird schon bald zu einem Großen Kristall Heranwachsen."},
		"width":32,
		"height":32
	}
}